
import { Injectable } from '@angular/core';

export interface VoiceSettings {
  gender: 'male' | 'female';
  rate: number;
  pitch: number;
}

@Injectable({
  providedIn: 'root',
})
export class LocalStorageService {
  private readonly SETTINGS_KEY = 'bhhc-ai-voice-settings';

  saveSettings(settings: VoiceSettings): void {
    try {
      localStorage.setItem(this.SETTINGS_KEY, JSON.stringify(settings));
    } catch (e) {
      console.error('Error saving settings to local storage', e);
    }
  }

  loadSettings(): VoiceSettings | null {
    try {
      const settingsJson = localStorage.getItem(this.SETTINGS_KEY);
      if (settingsJson) {
        return JSON.parse(settingsJson) as VoiceSettings;
      }
      return null;
    } catch (e) {
      console.error('Error loading settings from local storage', e);
      return null;
    }
  }
}
